# -*- coding: utf-8 -*-
"""
Created on Wed Sep  1 18:37:18 2021

@author: perlita
@title: Project 1
"""

import math
import matplotlib.pyplot as plt

print("Project 1")

print("")

# Setting variables to make my life easier
mil = 1000000
e = math.e
v = 435000

# Defining the functions to be used in all methods
def f(x):
    return mil*e**x+(v/x)*(e**x-1)-1564000

def fPrime(x):
    return (((mil*x**2)+(v*x)-v)*e**x+v)/x**2

# Setting max iterator and epsilon
maxIt = 50
epsilon = 1e-10

#--------------------------------------------------------------------------------

# Performing Tangent/Newton's Method

print("Tangent Line: ")

# First guess for tangent
xtan = 7.0

# List of f values for tangent
ftan_vals = []

# Just to know at what iteration do we stop
counter_tan = 0

for t in range(maxIt):
    
    fxtan = f(xtan)
    ftan_vals.append(abs(fxtan))
    
    counter_tan = counter_tan+1
    
    if abs(fxtan) < epsilon:
        break
    
    xkp = xtan - (fxtan/(fPrime(xtan)))
    xtan = xkp
    print("xtan ", counter_tan, "is: ", xtan)
    
#--------------------------------------------------------------------------------

# Performing Secant Method

print()

print("Secant Line")

# Initalizing guesses for secant
xsec1 = 7
xsec2 = 8

# List of values for secant
fsec_vals = []

# Just to know at what iteration do we stop
counter_sec = 0

for s in range (maxIt):
    
    fxsec1 = f(xsec1)
    fsec_vals.append(abs(fxsec1))
    
    counter_sec = counter_sec+1
    
    if abs(fxsec1) < epsilon or (f(xsec1) - f(xsec2)) == 0:
        break
    # I added the condition after the "or" to prevent errors of dividing by zero
    
    star = (xsec1 - xsec2)/(f(xsec1) - f(xsec2))
    xk = xsec1 - f(xsec1)*star
    
    xsec2 = xsec1
    xsec1 = xk
    print("xsec1 at iteration ", counter_sec, "is; ", xsec1)
    print("xsec2 at iteration ", counter_sec, "is: ", xsec2)

#--------------------------------------------------------------------------------

# This is just to see how closely accurate both tangent and secant line are
print()
print("Last tangent x is: ", xtan)
print("Last secant x is: ", xsec1)

#--------------------------------------------------------------------------------

# Performing Bisection

print()

print("Bisection: ")

# Initializing left and right
lk = 0
rk = 2

# List of values for bisection
fbi_vals = []

# Just to know at what iteration do we stop
counter_bi = 0

for b in range(maxIt):
    
    m = (lk + rk)/2
    fm = f(m)
    fbi_vals.append(abs(fm))
    counter_bi = counter_bi+1
    print("m at iteration ", counter_bi, " is: ", abs(fm))
    
    if abs(fm) < epsilon:
        break
    
    if fm*f(rk) > 0:
        lkp1 = lk
        rkp1 = m
    else:
        lkp1 = m
        rkp1 = rk
    
    lk = lkp1
    rk = rkp1
    
#--------------------------------------------------------------------------------

# This is just to see the difference of speed
print()
print("Approximation of x through Tangent was found at iteration: ", counter_tan-1)
print("Approximation of x through Secant was found at iteration: ", counter_sec-1)
print("Approximation of x through Bisection was found at iteration: ", counter_bi)

# Now we graph    
plt.plot(ftan_vals)
plt.plot(fsec_vals)
plt.plot(fbi_vals)
plt.title("f at Each Iteration")
plt.legend(['Tangent', 'Secant', 'Bisection'])
